<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class District extends Model 
{

    protected $table = 'districts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

}